--TODO: tee nist moduuleja joita voi kytt luokkien tapaan...
require 'g_level'
g_level.reset()

--INIT TEXTURES  -- adds a texture into ObjectManager<Texture>
h = FM_NEAREST;
lua_init_texture("background_forest", "data/images/taivastausta-parallax_2.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)

lua_init_texture("trees_1", "data/images/lvl_forest/puu_01.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_2", "data/images/lvl_forest/puu_02.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_3", "data/images/lvl_forest/puu_03.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_4", "data/images/lvl_forest/puu_04.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_5", "data/images/lvl_forest/puu_05.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_6", "data/images/lvl_forest/puu_06.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_7", "data/images/lvl_forest/puu_07.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_8", "data/images/lvl_forest/puunrunko.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)

lua_init_texture("road_1", "data/images/lvl_forest/uudettiet/uusimetsatie1.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("road_2", "data/images/lvl_forest/uudettiet/uusimetsatie2.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("road_3", "data/images/lvl_forest/uudettiet/uusimetsatie3.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("reuna_test", "data/images/lvl_forest/reuna1.png", h, WM_CLAMP, WM_CLAMP, AM_MODULATE)
lua_init_texture("reuna1", "data/images/lvl_forest/reuna.png", h, WM_CLAMP, WM_CLAMP, AM_MODULATE)
lua_init_texture("reuna2", "data/images/lvl_forest/reuna2.png", h, WM_CLAMP, WM_CLAMP, AM_MODULATE)

-- props
lua_init_texture("rock_1", "data/images/lvl_forest/muut/kivi.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("rock_2", "data/images/lvl_forest/muut/kivi2.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("grass_1", "data/images/lvl_forest/grass_cartoon.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("grass_2", "data/images/lvl_forest/grass_cartoon2.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("spikes", "data/images/lvl_forest/spikes.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)

-- background
lua_init_texture("bg_1", "data/images/lvl_forest/metsatausta.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("bg_2", "data/images/lvl_forest/metsatausta2.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)

-- foreground
lua_init_texture("fg_1", "data/images/lvl_forest/foreground_1.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("fg_2", "data/images/lvl_forest/foreground_2.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("fg_3", "data/images/lvl_forest/muut/foreground1.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)

-- 	exclamation mark
lua_init_texture("exclamationmark", "data/images/effects/huutomerkki.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)

-- Create Level
lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also

-- Create Layers
-- The index of the layers are auto incremented. This meaning that the first one to add is 0 and rest are in order of appearance...
lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
lua:create_layer(0.2,0.2,BM_DEFAULT) -- 1 = taustavuoret
lua:create_layer(0.4,0.4,BM_DEFAULT) -- 2 = taustamets
lua:create_layer(0.75,0.75,BM_DEFAULT) -- 3 = lhipuita
local parallax_x = 1.0
local parallax_y = 1.0
lua:create_layer(parallax_x,parallax_y,BM_DEFAULT) -- 4
lua:create_layer(parallax_x,parallax_y,BM_DEFAULT) -- 5
lua:create_layer(1.0,1.0,BM_DEFAULT) -- 6 = fysiikka + pelaaja
lua:create_layer(1.1,1.1,BM_DEFAULT) -- 7 = joitain ruoho/kivijuttuja
lua:create_layer(1.1,1.1,BM_DEFAULT) -- 8 = foreground

-- Background starts
local background_size = 0.20

-- background night sky 
lua:create_sprite("background", ST_TEXTURED,"background_forest", 0.0, 0.0) 
lua:sprite_shape("background",ST_TEXTURED, background_size*4096.0, background_size*2048.0)
lua:textured_sprite_tex_coords("background", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("background", 0)

-- background mountains
local bgMountainsLenght = 2.5
lua:create_sprite("background-mountains", ST_TEXTURED,"bg_1",1000.0, 80.0) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("background-mountains", 0.5, 0.5, 0.5 , 1.0)
lua:sprite_shape("background-mountains",ST_TEXTURED, background_size*4096.0*bgMountainsLenght, background_size*1024.0*1.5)
lua:textured_sprite_tex_coords("background-mountains", ST_TEXTURED, 0.0, -0.5, bgMountainsLenght, 1.0)
g_level.upload("background-mountains", 1)

-- background forest
local bgForestLenght = 3.5
lua:create_sprite("background-forest", ST_TEXTURED,"bg_2", 2500.0, -150.0) 
lua:sprite_color("background-forest", 0.5, 0.5, 0.5 , 1.0)
lua:sprite_shape("background-forest", ST_TEXTURED, 4096*bgForestLenght/4, 1024*1.5/4)
lua:textured_sprite_tex_coords("background-forest", ST_TEXTURED, -bgForestLenght, -0.5, 0.0, 1.0)
g_level.upload("background-forest", 2)


-- Background ends

-- lhipuut
lua:create_sprite("bgtree", ST_TEXTURED,"trees_3",              650.0, 0.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          200.0, 200.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("bgtree",                                        3)

lua:create_sprite("bgtree", ST_TEXTURED,"trees_2",              200.0, 0.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          230.0, 230.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("bgtree",                                        3)

lua:create_sprite("bgtree", ST_TEXTURED,"grass_2",              280.0, 0.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          128.0, 32.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 2.0, 1.0)
g_level.upload("bgtree",                                        3)

lua:create_sprite("bgtree", ST_TEXTURED,"trees_3",              2000.0, 0.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          200.0, 200.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("bgtree",                                        3)

lua:create_sprite("bgtree", ST_TEXTURED,"trees_4",              2700.0, 0.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          200.0, 200.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("bgtree",                                        3)
-- lhipuut loppuu

-- foreground 1 starts
lua:create_sprite("bgtree", ST_TEXTURED,"grass_2",              280.0, -100.0) 
lua:sprite_shape("bgtree",ST_TEXTURED,                          128.0, 32.0)
lua:textured_sprite_tex_coords("bgtree", ST_TEXTURED,           0.0, 0.0, 2.0, 1.0)
g_level.upload("bgtree", 7)

-- foreground 1 end

-- foreground 2 starts
lua:create_sprite("foreground-1", ST_TEXTURED, "fg_1", 160, -250.0)
lua:sprite_shape("foreground-1", ST_TEXTURED, 512.0, 64.0)
lua:textured_sprite_tex_coords("foreground-1", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("foreground-1", 8)

lua:create_sprite("foreground-1", ST_TEXTURED,"fg_2",1696, -250.0)
lua:sprite_shape("foreground-1",ST_TEXTURED, 1024.0, 64.0)
lua:textured_sprite_tex_coords("foreground-1", ST_TEXTURED, 0.0, 0.0, 2.0, 1.0)
g_level.upload("foreground-1", 8)

lua:create_sprite("foreground-1", ST_TEXTURED, "fg_1", 3232, -250.0)
lua:sprite_shape("foreground-1", ST_TEXTURED, 512.0, 64.0)
lua:textured_sprite_tex_coords("foreground-1", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("foreground-1", 8)

lua:create_sprite("foreground-1", ST_TEXTURED,"fg_2",4768, -250.0)
lua:sprite_shape("foreground-1",ST_TEXTURED, 1024.0, 64.0)
lua:textured_sprite_tex_coords("foreground-1", ST_TEXTURED, 0.0, 0.0, 2.0, 1.0)
g_level.upload("foreground-1", 8)

lua:create_sprite("foreground-1", ST_TEXTURED, "fg_1", 6304, -250.0)
lua:sprite_shape("foreground-1", ST_TEXTURED, 512.0, 64.0)
lua:textured_sprite_tex_coords("foreground-1", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("foreground-1", 8)
-- Foreground 2 ends

-- ROAD starts
lua:create_sprite("road", ST_TEXTURED,"road_3",               160.0, -150.0) 
lua:sprite_shape("road",ST_TEXTURED,                          256.0, 128.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           1.0, 0.0, 0.0, 1.0)
g_level.upload("road",                                        5)

lua:create_sprite("road", ST_TEXTURED,"road_2",               872.0, -150.0) 
lua:sprite_shape("road",ST_TEXTURED,                          256.0, 128.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("road",                                        5)  

lua:create_sprite("road", ST_TEXTURED,"road_3",               1336.0, -150.0) 
lua:sprite_shape("road",ST_TEXTURED,                          64.0, 128.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           0.0, 0.0, 0.25, 1)
g_level.upload("road",                                        5)

lua:create_sprite("road", ST_TEXTURED,"road_3",               1756.0, -150.0) 
lua:sprite_shape("road",ST_TEXTURED,                          256.0, 128.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("road",                                        5)

lua:create_sprite("road", ST_TEXTURED,"road_3",               2220.0, -160.0) 
lua:sprite_shape("road",ST_TEXTURED,                          64.0, 128.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           0.25, 0.0, 0, 1.0)
g_level.upload("road",                                        5)

lua:create_sprite("road", ST_TEXTURED,"road_1",               2800.0, -150.0) 
lua:sprite_shape("road",ST_TEXTURED,                          384.0, 128.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           1.5, 0.0, 0.0, 1.0)
g_level.upload("road",                                        5)

lua:create_sprite("road", ST_TEXTURED,"road_3",               3400.0, -80.0) 
lua:sprite_shape("road",ST_TEXTURED,                          64.0, 128.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           0, 0.0, 0.25, 1.0)
g_level.upload("road",                                        5)

lua:create_sprite("road", ST_TEXTURED,"road_2",               3650.0, -30.0) 
lua:sprite_shape("road",ST_TEXTURED,                          64.0, 128.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           0.25, 0.0, 0.0, 1.0)
g_level.upload("road",                                        5)

lua:create_sprite("road", ST_TEXTURED,"road_1",               4380.0, -150.0) 
lua:sprite_shape("road",ST_TEXTURED,                          512.0, 128.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           0.0, 0.0, 2.0, 1.0)
g_level.upload("road",                                        5)
-- ROAD ends

-- reunapalat

lua:create_sprite("road", ST_TEXTURED,"reuna1",               430.0, -195.0) 
lua:sprite_shape("road",ST_TEXTURED,                          14.0, 84.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("road",                                        5)

lua:create_sprite("road", ST_TEXTURED,"reuna2",               602.0, -195.0) 
lua:sprite_shape("road",ST_TEXTURED,                          14.0, 84.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("road",                                        5)

lua:create_sprite("road", ST_TEXTURED,"reuna1",               1135.0, -195.0) 
lua:sprite_shape("road",ST_TEXTURED,                          14.0, 84.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("road",                                        5)

lua:create_sprite("road", ST_TEXTURED,"reuna2",               1259.0, -195.0) 
lua:sprite_shape("road",ST_TEXTURED,                          14.0, 84.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("road",                                        5)

lua:create_sprite("road", ST_TEXTURED,"reuna1",               1414.0, -148.0) 
lua:sprite_shape("road",ST_TEXTURED,                          14.0, 84.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("road",                                        5)

lua:create_sprite("road", ST_TEXTURED,"reuna2",               1490.0, -195.0) 
lua:sprite_shape("road",ST_TEXTURED,                          14.0, 84.0)
lua:textured_sprite_tex_coords("road", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("road",                                        5)
-- reunapalat loppuu

-- jumping trees start
lua:create_sprite("jumping_tree", ST_TEXTURED,"trees_6",              380.0, 70.0) 
lua:sprite_shape("jumping_tree",ST_TEXTURED,                          200.0, 200.0)
lua:textured_sprite_tex_coords("jumping_tree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
lua:sprite_rotation("jumping_tree",                                   0.1)
g_level.upload("jumping_tree",                                        4)

lua:create_sprite("jumping_tree", ST_TEXTURED,"trees_6",              700.0, 42.0) 
lua:sprite_shape("jumping_tree",ST_TEXTURED,                          200.0, 200.0)
lua:textured_sprite_tex_coords("jumping_tree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("jumping_tree",                                        4)

lua:create_sprite("jumping_tree", ST_TEXTURED,"trees_6",              2000.0, 45.0) 
lua:sprite_shape("jumping_tree",ST_TEXTURED,                          200.0, 200.0)
lua:textured_sprite_tex_coords("jumping_tree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("jumping_tree",                                        4)

lua:create_sprite("jumping_tree", ST_TEXTURED,"trees_6",              2432.0, 68.0) 
lua:sprite_shape("jumping_tree",ST_TEXTURED,                          210.0, 210.0)
lua:textured_sprite_tex_coords("jumping_tree", ST_TEXTURED,           1.0, 0.0, 0.0, 1.0)
g_level.upload("jumping_tree",                                        4)

lua:create_sprite("jumping_tree", ST_TEXTURED,"trees_6",              2720.0, 40.0) 
lua:sprite_shape("jumping_tree",ST_TEXTURED,                          240, 240.0)
lua:textured_sprite_tex_coords("jumping_tree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("jumping_tree",                                        4)

lua:create_sprite("jumping_tree", ST_TEXTURED,"trees_6",              2943.0, 40.0) 
lua:sprite_shape("jumping_tree",ST_TEXTURED,                          206, 206.0)
lua:textured_sprite_tex_coords("jumping_tree", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("jumping_tree",                                        4)

lua:create_sprite("jumping_tree", ST_TEXTURED,"trees_6",              3140.0, 40.0) 
lua:sprite_shape("jumping_tree",ST_TEXTURED,                          180, 180.0)
lua:textured_sprite_tex_coords("jumping_tree", ST_TEXTURED,           1.0, 0.0, 0.0, 1.0)
lua:sprite_rotation("jumping_tree",                                   5.9)
g_level.upload("jumping_tree",                                        4)
-- jumping trees ends

-- spites start
local spike_1_x =  779.0;
local spike_1_y = -179.0;  
-- spite
lua:create_sprite("spikes", ST_TEXTURED,"spikes", spike_1_x, spike_1_y) 
lua:sprite_shape("spikes",ST_TEXTURED, 64.0, 32.0)
lua:textured_sprite_tex_coords("spikes", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("spikes", 5)
-- trigger
lua:create_shape("rectangle",PSC_RECTANGLE, 38.0,23.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","", spike_1_x, spike_1_y) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

local spike_2_x =  981.0;
local spike_2_y = -170.0;
-- spite
lua:create_sprite("spikes", ST_TEXTURED,"spikes", spike_2_x, spike_2_y) 
lua:sprite_shape("spikes",ST_TEXTURED, 64.0, 32.0)
lua:textured_sprite_tex_coords("spikes", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("spikes", 5)
-- trigger
lua:create_shape("rectangle",PSC_RECTANGLE, 38.0,23.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","", spike_2_x, spike_2_y) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

local spike_3_x =  2222.0;
local spike_3_y =  -114.0
-- spite
lua:create_sprite("spikes", ST_TEXTURED,"spikes", spike_3_x, spike_3_y) 
lua:sprite_shape("spikes",ST_TEXTURED, 64.0, 32.0)
lua:textured_sprite_tex_coords("spikes", ST_TEXTURED, 1.0, 0.0, 0.0, 1.0)
g_level.upload("spikes", 5)
-- trigger
lua:create_shape("rectangle",PSC_RECTANGLE, 38.0,23.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","", spike_3_x, spike_3_y) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

local spike_4_x =  2477.0;
local spike_4_y =  -145.0;
-- sprite
lua:create_sprite("spikes", ST_TEXTURED,"spikes", spike_4_x, spike_4_y) 
lua:sprite_shape("spikes",ST_TEXTURED, 64.0, 32.0)
lua:textured_sprite_tex_coords("spikes", ST_TEXTURED, 1.0, 0.0, 0.0, 1.0)
g_level.upload("spikes", 5)
-- trigger
lua:create_shape("rectangle",PSC_RECTANGLE, 38.0,23.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","", spike_4_x, spike_4_y) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

local spike_5_x =  2550.0;
local spike_5_y =  -130.0;
-- sprite
lua:create_sprite("spikes", ST_TEXTURED,"spikes", spike_5_x, spike_5_y) 
lua:sprite_shape("spikes",ST_TEXTURED, 64.0, 32.0)
lua:textured_sprite_tex_coords("spikes", ST_TEXTURED, 1.0, 0.0, 0.0, 1.0)
g_level.upload("spikes", 5)
-- trigger
lua:create_shape("rectangle",PSC_RECTANGLE, 38.0,23.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","", spike_5_x, spike_5_y) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

local spike_6_x =  2667.0;
local spike_6_y =  -122.0;
-- sprite
lua:create_sprite("spikes", ST_TEXTURED,"spikes", spike_6_x, spike_6_y) 
lua:sprite_shape("spikes",ST_TEXTURED, 64.0, 32.0)
lua:textured_sprite_tex_coords("spikes", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("spikes", 5)
-- trigger
lua:create_shape("rectangle",PSC_RECTANGLE, 38.0,23.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","", spike_6_x, spike_6_y) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

local spike_7_x =  2800.0;
local spike_7_y =  -130.0;
-- sprite
lua:create_sprite("spikes", ST_TEXTURED,"spikes", spike_7_x, spike_7_y) 
lua:sprite_shape("spikes",ST_TEXTURED, 64.0, 32.0)
lua:textured_sprite_tex_coords("spikes", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("spikes", 5)
-- trigger
lua:create_shape("rectangle",PSC_RECTANGLE, 38.0,23.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","", spike_7_x, spike_7_y) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

local spike_8_x =  2900.0;
local spike_8_y =  -125.0;
-- sprite
lua:create_sprite("spikes", ST_TEXTURED,"spikes", 2900.0, -125.0) 
lua:sprite_shape("spikes",ST_TEXTURED, 64.0, 32.0)
lua:textured_sprite_tex_coords("spikes", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("spikes", 5)
-- trigger
lua:create_shape("rectangle",PSC_RECTANGLE, 38.0,23.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","", spike_8_x, spike_8_y) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

local spike_9_x =  2993.0;
local spike_9_y =  -158.0;
-- sprite
lua:create_sprite("spikes", ST_TEXTURED,"spikes", spike_9_x, spike_9_y) 
lua:sprite_shape("spikes",ST_TEXTURED, 64.0, 32.0)
lua:textured_sprite_tex_coords("spikes", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("spikes", 5)
-- trigger
lua:create_shape("rectangle",PSC_RECTANGLE, 38.0,23.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","", spike_9_x, spike_9_y) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

local spike_10_x =  3050.0;
local spike_10_y =  -130.0;
-- sprite
lua:create_sprite("spikes", ST_TEXTURED,"spikes", spike_10_x, spike_10_y) 
lua:sprite_shape("spikes",ST_TEXTURED, 64.0, 32.0)
lua:textured_sprite_tex_coords("spikes", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("spikes", 5)
-- trigger
lua:create_shape("rectangle",PSC_RECTANGLE, 38.0,23.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","", spike_10_x, spike_10_y) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

local spike_11_x =  3155.0;
local spike_11_y =  -115.0;
-- sprite
lua:create_sprite("spikes", ST_TEXTURED,"spikes", spike_11_x, spike_11_y) 
lua:sprite_shape("spikes",ST_TEXTURED, 64.0, 32.0)
lua:textured_sprite_tex_coords("spikes", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("spikes", 5)
-- trigger
lua:create_shape("rectangle",PSC_RECTANGLE, 38.0,23.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","", spike_11_x, spike_11_y) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

-- spikes end

--Segments start
--road 1
lua:create_segment(-163, -145)
lua:add_segment(-93, -147)
lua:add_segment(-42, -142)
lua:add_segment(13, -131)
lua:add_segment(65, -120)
lua:add_segment(111, -104)
lua:add_segment(140, -93)
lua:add_segment(180, -89)
lua:add_segment(226, -88)
lua:add_segment(252, -87)
lua:add_segment(294, -102)
lua:add_segment(328, -115)
lua:add_segment(360, -130)
lua:add_segment(388, -143)
lua:add_segment(418, -148)
lua:upload_segmentstrip()

--tree1 branch 1
lua:create_segment(258, -39)
lua:add_segment(287,-19)
lua:add_segment(325, -13)
lua:add_segment(335, -21)
lua:add_segment(347, -23)
lua:upload_segmentstrip()

lua:create_segment(240, 49)
lua:add_segment(275, 67)
lua:add_segment(328, 77)
lua:add_segment(355, 68)
lua:add_segment(363, 68)
lua:upload_segmentstrip()

lua:create_segment(281, 163)
lua:add_segment( 296, 168)
lua:add_segment(355, 168)
lua:add_segment(382, 131)
lua:add_segment(458, 142)
lua:add_segment(508, 129)
lua:upload_segmentstrip()

lua:create_segment(390, 33)
lua:add_segment(407, 32)
lua:add_segment(450, 41)
lua:add_segment(475, 32)
lua:upload_segmentstrip()

--road 2
lua:create_segment(614, -148)
lua:add_segment(645, -161)
lua:add_segment(699, -184)
lua:add_segment(737, -197)
lua:add_segment(774, -204)
lua:add_segment(820, -204)
lua:add_segment(869, -205)
lua:add_segment(923, -200)
lua:add_segment(965, -192)
lua:add_segment(1032, -176)
lua:add_segment(1078, -162)
lua:add_segment(1115, -146)
lua:add_segment(1127, -146)
lua:upload_segmentstrip()

--tree 2
lua:create_segment(558, -122,605, -104)
lua:add_segment(621, -105)
lua:add_segment(629, -105)
lua:upload_segmentstrip()

lua:create_segment(568, -54)
lua:add_segment(599, -37)
lua:add_segment(636, -37)
lua:add_segment(650, -46)
lua:add_segment(660, -48)
lua:upload_segmentstrip()

lua:create_segment(561, 37)
lua:add_segment(596, 49)
lua:add_segment(654, 51)
lua:add_segment(674, 46)
lua:add_segment(682, 45)
lua:upload_segmentstrip()

lua:create_segment(612, 145)
lua:add_segment(631, 149)
lua:add_segment(686, 141)
lua:add_segment(711, 101)
lua:add_segment(766, 105)
lua:add_segment(782, 106)
lua:add_segment(838, 86)
lua:upload_segmentstrip()

lua:create_segment(1271, -146)
lua:add_segment(1293, -146)
lua:add_segment(1346, -121)
lua:add_segment(1381, -109)
lua:add_segment(1400, -99)
lua:upload_segmentstrip()

--road 3
lua:create_segment(705, 1)
lua:add_segment(717, 2)
lua:add_segment(768, 8)
lua:add_segment(796, -8)
lua:upload_segmentstrip()

--road 4
lua:create_segment(1500, -148)
lua:add_segment(1523, -147)
lua:add_segment(1562, -129)
lua:add_segment(1620, -104)
lua:add_segment(1661, -96)
lua:add_segment(1701, -92)
lua:add_segment(1758, -98)
lua:add_segment(1809, -112)
lua:add_segment(1854, -122)
lua:add_segment(1911, -134)
lua:add_segment(1954, -143)
lua:add_segment(1996, -149)
lua:add_segment(2012, -149)
lua:upload_segmentstrip()

lua:create_segment(1867, -52)
lua:add_segment(1900, -33)
lua:add_segment(1938, -33)
lua:add_segment(1950, -43)
lua:add_segment(1960, -45)
lua:upload_segmentstrip()

lua:create_segment(2001, 5)
lua:add_segment(2044, 7)
lua:add_segment(2067, 9)
lua:add_segment(2099, -6)
lua:upload_segmentstrip()

lua:create_segment(1862, 39)
lua:add_segment(1892, 50)
lua:add_segment(1950, 57)
lua:add_segment(1980, 44)

lua:create_segment(1913, 150)
lua:add_segment(1932, 153)
lua:add_segment(1982, 146)
lua:add_segment(2011, 106)
lua:add_segment(2056, 107)
lua:add_segment(2085, 110)
lua:add_segment(2139, 89)

--road 5
lua:create_segment(2156, -108)
lua:add_segment(2193, -127)
lua:add_segment(2230, -141)
lua:add_segment(2262, -157)
lua:add_segment(2282, -159)

lua:create_segment(2328, 15)
lua:add_segment(2361, 31)
lua:add_segment(2413, 25)
lua:add_segment(2427, 24)

lua:create_segment(2288, 115)
lua:add_segment(2345, 135)
lua:add_segment(2422, 128)
lua:add_segment(2447, 171)
lua:add_segment(2491, 179)

lua:create_segment(2456, 69)
lua:add_segment(2483, 77)
lua:add_segment(2546, 73)
lua:add_segment(2571, 65)

lua:create_segment(2475, -29)
lua:add_segment(2489, -27)
lua:add_segment(2500, -14)
lua:add_segment(2536, -17)
lua:add_segment(2559, -29)
lua:upload_segmentstrip()

lua:create_segment(2509, -96)
lua:add_segment(2536, -91.9999)
lua:add_segment(2567, -100)
lua:upload_segmentstrip()

--road
lua:create_segment(2416, -170)
lua:add_segment(2448, -172)
lua:add_segment(2493, -173)
lua:add_segment(2529, -173)
lua:add_segment(2569, -168)
lua:add_segment(2606, -161)
lua:add_segment(2634, -150)
lua:add_segment(2682, -148)
lua:add_segment(2729, -152)
lua:add_segment(2777, -158)
lua:add_segment(2832, -160)
lua:add_segment(2861, -163)
lua:add_segment(2910, -169)
lua:add_segment(2968, -175)
lua:add_segment(3001, -177)
lua:add_segment(3041, -174)
lua:add_segment(3077, -167)
lua:add_segment(3112, -159)
lua:add_segment(3143, -152)
lua:add_segment(3165, -148)
lua:add_segment(3183, -149)
lua:upload_segmentstrip()

lua:create_segment(2562, -78)
lua:add_segment(2603, -53)
lua:add_segment(2642, -54)
lua:add_segment(2661, -68)
lua:add_segment(2668, -68)
lua:upload_segmentstrip()

lua:create_segment(2558, 34)
lua:add_segment(2591, 46)
lua:add_segment(2659, 53)
lua:add_segment(2693, 42)
lua:add_segment(2701, 42)
lua:upload_segmentstrip()

lua:create_segment(2615, 162)
lua:add_segment(2632, 169)
lua:add_segment(2703, 161)
lua:add_segment(2736, 110)
lua:add_segment(2818, 121)
lua:add_segment(2881, 95)
lua:upload_segmentstrip()

lua:create_segment(2726, -8.99995)
lua:add_segment(2743, -7.99998)
lua:add_segment(2801, -2.99995)
lua:add_segment(2838, -23)
lua:upload_segmentstrip()

lua:create_segment(2808, -60)
lua:add_segment(2842, -39)
lua:add_segment(2878, -40)
lua:add_segment(2892, -52)
lua:add_segment(2906, -52)
lua:upload_segmentstrip()

lua:create_segment(2800, 34)
lua:add_segment(2835, 45)
lua:add_segment(2894, 49)
lua:add_segment(2918, 38)
lua:add_segment(2925, 38)
lua:upload_segmentstrip()

lua:create_segment(2852, 145)
lua:add_segment(2873, 150)
lua:add_segment(2926, 142)
lua:add_segment(2956, 99)
lua:add_segment(3026, 108)
lua:add_segment(3078, 88)
lua:upload_segmentstrip()

lua:create_segment(2947, -0.999954)
lua:add_segment(2967, -2.99995)
lua:add_segment(3012, 4.00005)
lua:add_segment(3037, -6.99995)
lua:upload_segmentstrip()

lua:create_segment(3052, 34)
lua:add_segment(3073, 34)
lua:add_segment(3116, 9.00005)
lua:add_segment(3124, 9.00005)
lua:upload_segmentstrip()

lua:create_segment(3039, 123)
lua:add_segment(3091, 122)
lua:add_segment(3126, 104)
lua:add_segment(3146, 94)
lua:add_segment(3186, 118)
lua:add_segment(3223, 110)
lua:upload_segmentstrip()

lua:create_segment(3159, 32)
lua:add_segment(3184, 33)
lua:add_segment(3229, 9.00005)
lua:add_segment(3250, -6.99995)
lua:upload_segmentstrip()

lua:create_segment(3145, -54)
lua:add_segment(3168, -46.9999)
lua:add_segment(3196, -59)
lua:add_segment(3215, -84)
lua:upload_segmentstrip()

lua:create_segment(3336, -81)
lua:add_segment(3363, -78)
lua:add_segment(3423, -46)
lua:add_segment(3463, -30)
lua:upload_segmentstrip()

lua:create_segment(3587, -73)
lua:add_segment(3632, -61)
lua:add_segment(3678, -43)
lua:add_segment(3712, -28)
lua:upload_segmentstrip()

--road final
lua:create_segment(3869, -149)
lua:add_segment(3903, -152)
lua:add_segment(3963, -170)
lua:add_segment(4046, -175)
lua:add_segment(4094, -174)
lua:add_segment(4167, -165)
lua:add_segment(4236, -161)
lua:add_segment(4297, -160)
lua:add_segment(4356, -150)
lua:add_segment(4402, -149)
lua:add_segment(4451, -164)
lua:add_segment(4496, -167)
lua:add_segment(4540, -167)
lua:add_segment(4592, -176)
lua:add_segment(4626, -170)
lua:add_segment(4672, -164)
lua:add_segment(4745, -162)
lua:add_segment(4800, -159)
lua:add_segment(4847, -152)
lua:add_segment(4873, -150)
lua:add_segment(4891, -149)
lua:upload_segmentstrip()
--Segmetns end

--Triggers start
--lower game over
lua:create_shape("rectangle",PSC_RECTANGLE,5500.0,60.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "","data/scripts/srt_game_over.lua",2443.0,-342.0) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

--left game over
lua:create_shape("rectangle",PSC_RECTANGLE,40.0,1000.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","", -136.0,342.0) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

--right level finished
local use_x =  4800.0;
local use_y =   -50.0;
local use_radius = 100.0;
lua:create_circle("mark", 0, 0, use_radius)
lua:create_trigger("gate", TT_GATE, "data/scripts/test/show_enter_mark.lua","data/scripts/test/show_leave_mark.lua", use_x, use_y)    --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "mark")                  --name, type, shape_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_upload("gate",0) --name
lua:create_circle("use", 0, 0, use_radius)
g_levelname = "data/scripts/lvl_bar.lua"
lua:create_trigger("use", TT_USE, "data/scripts/srt_level_finished.lua", "", use_x, use_y)    --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("use", TT_USE, "use")                  --name, type, shape_name
lua:trigger_add_group_can_use_me("use", TT_USE, "player") --name, type, group_name
lua:trigger_add_group_i_belong_to("use", TT_USE, "killer") --name, type, group_name
lua:trigger_upload("use",1) --name,parameter

-- right game over
lua:create_shape("rectangle",PSC_RECTANGLE,40.0,1000.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","",4910.0,342.0) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

--Triggers end

--pendulum stuffs
lua:do_file("data/scripts/test/pendulum_examples.lua")


--Player
--INIT PLAYER
lua:do_file("data/scripts/crt_player_trigger.lua",0)
lua:init_camera_binder(-96.0, 4890.0, -312.0, 1000.0) -- left, right, bottom, up
lua:upload_player_to_layer(6)  --index of the layer
lua:creature_translation("player", CPT_PLAYER, 600.0,1500.0) -- set the player to it's right position
--Player end

lua:set_game_state(GS_PLAY) -- sets the game state to menu. thus you are able to use the menu commands
